define("tc/event-delete-dialog", ["jquery"],
    function (
        $
    )
    {
    "use strict";
    return function (calendarDiv, anEvent, CalendarPlugin) {
        var confirmEventDeleteDialog;
        var deleteEventFunction = function (options, _confirmEventDeleteDialog) {
            if (!CalendarPlugin.isProcessingEvent(calendarDiv)) {
                CalendarPlugin.setProcessingEvent(calendarDiv, true, _confirmEventDeleteDialog);

                CalendarPlugin.deleteEvent(
                    calendarDiv,
                    options,
                    function (XMLHttpRequest, textStatus, errorThrown) {
                        CalendarPlugin.showAjaxError(calendarDiv, XMLHttpRequest, textStatus, errorThrown, CalendarPlugin.ERROR_CLASS_EVENT_DELETE);
                        _confirmEventDeleteDialog.hide();
                        CalendarPlugin.setProcessingEvent(calendarDiv, false, _confirmEventDeleteDialog);
                    },
                    function (responseEntity) {
                        if (responseEntity.success) {
                            var eventSubCalendar = CalendarPlugin.getSubCalendar(calendarDiv, anEvent.subCalendarId);
                            var eventType = anEvent.eventType;

                            var property;
                            if(eventType === "custom" && eventSubCalendar && eventSubCalendar.customEventTypes && eventSubCalendar.customEventTypes.length) {
                                $.each(eventSubCalendar.customEventTypes, function(index, item) {
                                    if(item.customEventTypeId === anEvent.customEventTypeId) {
                                        property = {
                                            customEventTypeName: item.title
                                        };
                                    }
                                });
                            }

                            Confluence.TeamCalendars.fireEventForAnalytics("event.delete.default." + eventType + ".context." + CalendarPlugin.getParameter(calendarDiv, "calendarContext"), property);

                            CalendarPlugin.setGenericErrors(calendarDiv, null, CalendarPlugin.ERROR_CLASS_EVENT_DELETE);
                            if (options.singleInstance) {
                                CalendarPlugin.getCalendarPanel(calendarDiv).fullCalendar("removeEvents", [ anEvent.id ]);
                            } else {
                                CalendarPlugin.reloadSubCalendar(calendarDiv, eventSubCalendar.id || eventSubCalendar.parentId);
                            }
                        } else {
                            CalendarPlugin.setGenericErrors(calendarDiv, AJS.I18n.getText("calendar3.error.unknown"), CalendarPlugin.ERROR_CLASS_EVENT_DELETE);
                        }

                        _confirmEventDeleteDialog.hide();
                        CalendarPlugin.setProcessingEvent(calendarDiv, false, _confirmEventDeleteDialog);
                    });
                return false;
            }
        };

        if (anEvent.recur) {
            // Recurring event
            confirmEventDeleteDialog = new AJS.Dialog({width: 550, height: 270, id: "tc-confirm-event-delete"});
            confirmEventDeleteDialog.addHeader(AJS.I18n.getText("calendar3.heading.confirmdeleterecurringevent"));
            confirmEventDeleteDialog.addPanel(
                "",
                Confluence.TeamCalendars.Templates.confirmRecurringEventDelete({ "elementIdSuffix": CalendarPlugin.getParameter(calendarDiv, "elementIdSuffix") }),
                "tc-delete-event-confirmation-panel");

            var deleteDialogPanel = confirmEventDeleteDialog.getCurrentPanel().body;
            var spinner =  $("<span class='spinner hidden aui-icon aui-icon-wait'></span>");
            var addingSpinner = function (confirmEventDeleteDialog){
                var buttonPanel = confirmEventDeleteDialog.getPage(0).buttonpanel;
                // add spinner
                spinner.prependTo(buttonPanel);
            };

            confirmEventDeleteDialog.enableOkButton = function (){
                $(":button", deleteDialogPanel).each(function(index, btn){
                    $(btn).removeAttr("disabled")
                        .removeClass("ui-state-disabled");
                });

                spinner.addClass("hidden");
            };

            confirmEventDeleteDialog.disableOkButton = function () {
                $(":button", deleteDialogPanel).each(function(index, btn){
                    $(btn).attr("disabled", "disabled")
                        .addClass("ui-state-disabled");
                });

                spinner.removeClass("hidden");
            }

            $(".tc-delete-this-instance-only", deleteDialogPanel).click(function () {
                deleteEventFunction({
                    subCalendarId: anEvent.subCalendarId,
                    uid: anEvent.id,
                    recurrenceId: anEvent.recurId || "",
                    originalStart: anEvent.originalStart || "",
                    singleInstance: true
                }, confirmEventDeleteDialog);
                return false;
            });

            $(".tc-delete-future-instances-only", deleteDialogPanel).click(function () {
                deleteEventFunction({
                    subCalendarId: anEvent.subCalendarId,
                    uid: anEvent.id,
                    recurUntil: $.fullCalendar.formatDate(anEvent.start, "yyyyMMdd")
                }, confirmEventDeleteDialog);
                return false;
            });

            $(".tc-delete-all-instances", deleteDialogPanel).click(function () {
                deleteEventFunction({
                    subCalendarId: anEvent.subCalendarId,
                    uid: anEvent.id
                }, confirmEventDeleteDialog);
                return false;
            });

            confirmEventDeleteDialog.addLink(AJS.I18n.getText("cancel.name"), function () {
                confirmEventDeleteDialog.hide();
                return false;
            });

            addingSpinner(confirmEventDeleteDialog);
        } else {
            confirmEventDeleteDialog = new AJS.Dialog(280, 170);
            confirmEventDeleteDialog.addHeader(AJS.I18n.getText("calendar3.heading.confirmdeleteevent"));
            confirmEventDeleteDialog.addPanel(
                "",
                Confluence.TeamCalendars.Templates.confirmEventDelete(),
                "tc-delete-event-confirmation-panel");

            confirmEventDeleteDialog.addButton(AJS.I18n.getText("yes.name"), function () {
                deleteEventFunction({
                    subCalendarId: anEvent.subCalendarId,
                    uid: anEvent.id
                }, confirmEventDeleteDialog);
            });

            confirmEventDeleteDialog.addLink(AJS.I18n.getText("cancel.name"), function () {
                confirmEventDeleteDialog.hide();
                return false;
            });
        }

        return confirmEventDeleteDialog;
    };
});