define("tc/customeventtype-list",
    [
        "jquery",
        "tc-backbone",
        "tc/customeventtype-model",
        "underscore"
    ],
    function (
        $,
        Backbone,
        CustomeEventTypeModel,
        _)
    {
        "use strict";
        var customeEventTypeList = Backbone.Collection.extend({
            model: CustomeEventTypeModel,

            // localStorage: new LocalStorage("customeventtypes-backbone"),

            select : function(selectedId){
                this.selectedId = selectedId;
                var resultItem = this.selectedItem();
                this.trigger("selected", this);
                return resultItem;
            },

            selectedItem : function(){
                if (this.selectedId)
                {
                    return this.findWhere({ id : this.selectedId});
                }

                return undefined;
            },

            defaultEventTypes: function() {
                return this.where({isCustomEvent : false});
            },

            customEventTypes: function() {
                return this.where({isCustomEvent : true});
            },

            initialize: function () {
                // Default sort field and direction
                this.sortField = "name";
                this.sortDirection = "ASC";
            },

            setSortField: function (field, direction) {
                this.sortField = field;
                this.sortDirection = direction;
            },

            comparator: function (modelItem) {
                return modelItem.get(this.sortField);
            },

            // Overriding sortBy
            sortBy: function (iterator, context) {
                var obj = this.models,
                    direction = this.sortDirection;

                return _.pluck(_.map(obj, function (value, index, list) {
                    return {
                        value: value,
                        index: index,
                        criteria: iterator.call(context, value, index, list)
                    };
                }).sort(function (left, right) {
                    // swap a and b for reverse sort
                    var itemA = direction === "ASC" ? left.criteria : right.criteria,
                        itemB = direction === "ASC" ? right.criteria : left.criteria;

                    if (itemA !== itemB) {
                      if (itemA > itemB || itemA === void 0) {
                          return 1;
                      }
                      if (itemA < itemB || itemB === void 0) {
                          return -1;
                      }
                    }
                    return left.index < right.index ? -1 : 1;
                }), 'value');
            }
        });

        return customeEventTypeList;
    }
);