define("tc/calendar-restriction-dialog",
    [
        "jquery",
        "underscore",
        "tc-backbone",
        "tc/templates",
        "tc/calendar-util"
    ], function
        (
            $,
            _,
            Backbone,
            Templates,
            CalUtil
        )
    {
        "use strict";

        var RestrictionDialog = Backbone.View.extend({
            restrictionDialog : null,
            calendarDiv: null,
            subCalendar: null,
            calendarPlugin : null,
            calendarCache : null,
            editDialog: null,
            initialize: function(options){
                this.calendarDiv = options.calendarDiv;
                this.subCalendar = options.subCalendar;
                this.calendarPlugin = options.calendarPlugin;
                this.calendarCache = options.calendarCache;
                this.editDialog = options.editDialog;
                this.$el.html(Templates.restrictSubCalendar({
                        "elementIdSuffix" : this.calendarPlugin.getParameter(this.calendarDiv, "elementIdSuffix"),
                        "pdlEnabled" : CalUtil.isPDLEnabled()
                    }));
                this.editDialog.addPanel(AJS.I18n.getText("calendar3.restrictsubcalendar"), this.$el, "setup-calendar-panel");
            },
            render: function() {
                var that = this;

                //process behaviour when restriction panel active
                this.editDialog.getCurrentPanel().onselect = function() {
                    $("#edit-calendar-dialog").find(".button-panel-button.submit").removeClass("hidden");
                };

                var restrictionsForm = $("form", that.editDialog.getCurrentPanel().body);
                $("input[name='subCalendarId']", restrictionsForm).val(that.subCalendar.id || "");
                $(".field-group-permissions", restrictionsForm).each(function() {
                  var restrictionsFieldGroup = $(this);

                  $(".permissions-details", restrictionsFieldGroup).each(function(permissionsFieldGroupIdx) {
                      var permissionsFieldGroup = $(this);
                      var userAutoCompleteInput = $(".autocomplete-user", restrictionsFieldGroup);

                      userAutoCompleteInput.bind("selected.autocomplete-user", function(e, selection) {
                          that._addUsersToPermissionFieldGroup(restrictionsFieldGroup, {
                              "id" : selection.content.userKey || selection.content.username,
                              "name" : selection.content.username,
                              "fullName" : selection.content.title,
                              "avatarUrl" : selection.content.thumbnailLink.href
                          }, true);
                          userAutoCompleteInput.val("");
                      }).focus(function() {
                          if (userAutoCompleteInput.hasClass("with-hint")) {
                              userAutoCompleteInput.removeClass("with-hint").val("");
                          }
                      }).blur(function() {
                          if (!userAutoCompleteInput.val()) {
                              userAutoCompleteInput.addClass("with-hint").val(AJS.I18n.getText("calendar3.restrict.enterusername"));
                          }
                      }).keydown(function(jsEvent) {
                          if (jsEvent.keyCode === 13 && !$(".autocomplete .aui-dropdown .active").length) {
                              setTimeout(function() {
                                  var userAutoCompleteInputValue = userAutoCompleteInput.val();
                                  if (userAutoCompleteInputValue) {
                                      that._addGroupsToPermissionFieldGroup(restrictionsFieldGroup, userAutoCompleteInputValue.split(","), true, true);
                                      userAutoCompleteInput.val("");
                                  } else {
                                      that.submitRestrictionsDialog(that.editDialog);
                                  }
                              }, 300);

                              // Hide no results
                              $(".autocomplete .aui-dropdown .no-results").trigger("click");
                              return false;
                          }
                      });

                      $(".group-picker-trigger", permissionsFieldGroup).click(function() {
                          var callbackName = "Team_Calendars_group_picker_callback_" + that.calendarPlugin.getParameter(that.calendarDiv, "elementIdSuffix") + "_" + permissionsFieldGroupIdx;
                          window[callbackName] = function(groupNames) {
                              that._addGroupsToPermissionFieldGroup(restrictionsFieldGroup, groupNames.split(","), false, true);
                          };
                          window.open(
                                  that.calendarPlugin.getParameter(that.calendarDiv, "baseUrl") + "/spaces/opengrouppicker.action?key=ds&startIndex=0&actionName=dosearchgroups.action&onPopupSubmit=" + encodeURIComponent(callbackName),
                              callbackName,
                              "dependent=1,height=512,width=384,resizable=1,status=0"
                          ).focus();
                          return false;
                      });
                  });
                });

                $(".field-group-permissions", restrictionsForm).each(function() {
                  var restrictionsFieldGroup = $(this);
                  var viewRestrictionsRadio = $(".option-view-restrictions", restrictionsFieldGroup);
                  var editRestrictionsRadio = $(".option-edit-restrictions", restrictionsFieldGroup);

                  that._addUsersToPermissionFieldGroup(restrictionsFieldGroup, that.subCalendar.usersPermittedToEdit || []);
                  that._addGroupsToPermissionFieldGroup(restrictionsFieldGroup, that.subCalendar.groupsPermittedToEdit|| []);

                  editRestrictionsRadio.removeAttr("checked");
                  viewRestrictionsRadio.attr("checked", "checked");
                  that._addUsersToPermissionFieldGroup(restrictionsFieldGroup, that.subCalendar.usersPermittedToView || []);
                  that._addGroupsToPermissionFieldGroup(restrictionsFieldGroup, that.subCalendar.groupsPermittedToView || []);
                });

                return that.editDialog;
            },
            submitRestrictionsDialog : function (restrictionsDialog) {
                var that = this;

                var restrictionsForm = $("form", restrictionsDialog.getCurrentPanel().body);
                var getUserRestrictions = function(restrictionsGroup) {
                    return $.map($(".permitted-entity", restrictionsGroup), function(permittedEntity) {
                        var entity = $(permittedEntity).data("entity");
                        return $.isPlainObject(entity) ? entity.id : null;
                    });
                };
                var getGroupRestrictions = function(permissionsGroup) {
                    return $.map($(".permitted-entity", permissionsGroup), function(permittedEntity) {
                        var entity = $(permittedEntity).data("entity");
                        return typeof entity === "string" ? entity : null;
                    });
                };

                var requestData = {subCalendarId: $("input[name='subCalendarId']", restrictionsForm).val()};
                CalUtil.putCalendarContextParams(requestData);

                var viewRestrictionsGroup = $(".view-permissions", restrictionsForm);
                if (viewRestrictionsGroup.length) {
                    requestData.updateUsersPermittedToView = true;
                    requestData.usersPermittedToView = getUserRestrictions(viewRestrictionsGroup);
                    if (!requestData.usersPermittedToView.length) {
                        delete requestData.usersPermittedToView;
                    }

                    requestData.updateGroupsPermittedToView = true;
                    requestData.groupsPermittedToView = getGroupRestrictions(viewRestrictionsGroup);
                    if (!requestData.groupsPermittedToView.length) {
                        delete requestData.groupsPermittedToView;
                    }
                }

                var editRestrictionsGroup = $(".edit-permissions", restrictionsForm);
                if (editRestrictionsGroup.length) {
                    requestData.updateUsersPermittedToEdit = true;
                    requestData.usersPermittedToEdit = getUserRestrictions(editRestrictionsGroup);
                    if (!requestData.usersPermittedToEdit.length) {
                        delete requestData.usersPermittedToEdit;
                    }

                    requestData.updateGroupsPermittedToEdit = true;
                    requestData.groupsPermittedToEdit = getGroupRestrictions(editRestrictionsGroup);
                    if (!requestData.groupsPermittedToEdit.length) {
                        delete requestData.groupsPermittedToEdit;
                    }
                }

                if (that.calendarPlugin.getParameter(that.calendarDiv, "include")) {
                    requestData.include = that.calendarPlugin.getParameter(that.calendarDiv, "include");
                }

                if (!that.calendarPlugin.isProcessingSubCalendar(that.calendarDiv)) {
                    var spinnerDefer = that.calendarPlugin.setSubCalendarSpinnerIconVisible(true);

                    $.ajax({
                        cache: false,
                        converters : {
                            "text json" : function(jsonObject) {
                                return jsonObject;
                            }
                        },
                        data : requestData,
                        dataType : "json",
                        dataFilter : function(data) {
                            var subCalendarsResponseEntity = $.parseJSON(data);
                            if (subCalendarsResponseEntity.success) {
                                that.calendarPlugin.mergeSubCalendarObjectsToArray(subCalendarsResponseEntity.payload);
                            }
                            return subCalendarsResponseEntity;
                        },
                        error: function(XMLHttpRequest, textStatus, errorThrown) {
                            that.calendarPlugin.showAjaxError(that.calendarDiv, XMLHttpRequest, textStatus, errorThrown, that.calendarPlugin.ERROR_CLASS_SUB_CALENDAR_UPDATE);
                            that.calendarPlugin.setProcessingSubCalendar(that.calendarDiv, false);
                        },
                        success : function(responseEntity) {
                            that.calendarCache.removeCalendar(that.subCalendar.id);
                            that.calendarPlugin.setGenericErrors(that.calendarDiv, null, that.calendarPlugin.ERROR_CLASS_SUB_CALENDAR_UPDATE);
                            that.calendarPlugin.setSubCalendars(that.calendarDiv, responseEntity.payload);
                            that.calendarPlugin.updateAvailableSubCalendarsInSubCalendarPanel(that.calendarDiv);
                            that.calendarPlugin.setProcessingSubCalendar(that.calendarDiv, false);

                            restrictionsDialog.hide();
                        },
                        complete: function(){
                            if (spinnerDefer) spinnerDefer.resolve();
                        },
                        type : "PUT",
                        timeout : that.calendarPlugin.ajaxTimeout,
                        url : that.calendarPlugin.getCalendarServiceBaseUrl(that.calendarDiv, "/subcalendars/restrictions.json")
                    });
                }

                return false;

            },
            _showHideHint : function(restrictionGroup) {
                var permissionsTable = $(".permission-table", restrictionGroup);
                var permittedEntities = $(".permitted-entities", permissionsTable);

                if ($(".permitted-entity", permittedEntities).length) {
                    restrictionGroup.addClass("has-restrictions");
                    permissionsTable.removeClass("hidden");
                } else {
                    restrictionGroup.removeClass("has-restrictions");
                    permissionsTable.addClass("hidden");
                }
            },
            _getRestrictionGroup : function(restrictionsFieldGroup) {
                return $("input[name='restriction-type']:checked", restrictionsFieldGroup).val() === "view" ?
                       $(".view-permissions", restrictionsFieldGroup) : $(".edit-permissions", restrictionsFieldGroup);
            },
            _addUsersToPermissionFieldGroup : function(restrictionsFieldGroup, users, addUsersToOfList) {
                var that = this;
                var restrictionGroup = that._getRestrictionGroup(restrictionsFieldGroup);
                var permittedEntities = $(".permitted-entities", restrictionGroup);
                var isUserAdded = function(user) {
                    return $(".permitted-entity", permittedEntities).filter(function() {
                        var permittedEntity = $(this).data("entity");
                        return $.isPlainObject(permittedEntity) && permittedEntity.id === user.id;
                    }).length;
                };

                var usersArray;
                if ($.isPlainObject(users)) {
                    usersArray = [ users ];
                } else if ($.isArray(users)) {
                    usersArray = users;
                }

                if ($.isArray(usersArray)) {
                    $.each(usersArray, function(userIdx, user) {
                        if (!isUserAdded(user)) {
                            var permittedEntity = $(document.createElement("tr")).addClass("permitted-entity").append(
                                $(document.createElement("td")).append(
                                    $(document.createElement("img")).attr("src", user.avatarUrl)
                                ).append(
                                    $(document.createElement("span")).text(user.fullName).append(
                                        $(document.createElement("span")).addClass("user-name").text("(" + user.name + ")")
                                    )
                                )
                            ).append(
                                $(document.createElement("td")).addClass("delete-permitted-entity").append(
                                    $(document.createElement("a")).addClass("remove").attr("href", "#").attr("title", AJS.I18n.getText("delete.name")
                                    ).text(AJS.I18n.getText("delete.name")
                                    ).click(function() {
                                            $(this).closest("tr").remove();
                                            that._showHideHint(restrictionGroup);
                                            return false;
                                        })
                                )
                            ).data("entity", user);

                            if (addUsersToOfList) {
                                permittedEntity.prependTo(permittedEntities);
                            } else {
                                permittedEntities.append(permittedEntity);
                            }
                        }
                    });
                    $(".error", restrictionsFieldGroup).empty();
                }

                that._showHideHint(restrictionGroup);
            },
            _addGroupsToPermissionFieldGroup : function(restrictionsFieldGroup, groupNames, validate, addGroupsToTopOfList) {
                var that = this;
                var restrictionGroup = that._getRestrictionGroup(restrictionsFieldGroup),
                    permittedEntities = $(".permitted-entities", restrictionGroup),
                    isGroupAdded = function(_groupName) {
                        return $(".permitted-entity", permittedEntities).filter(function() {
                            var permittedEntity = $(this).data("entity");
                            return (typeof permittedEntity === "string") && permittedEntity === _groupName;
                        }).length;
                    },
                    createGroupAvatarCell = function(_groupName) {
                        if (Confluence.TeamCalendars.isPDLEnabled()) {
                            return $("<td/>").append(
                                $("<span/>", { "class" : "group", "text" : _groupName })
                            );
                        } else {
                            return $("<td/>").append(
                                $("<img/>", { "src" : Confluence.getBaseUrl() + "/images/icons/group_16.gif" })
                            ).append(
                                $("<span/>", { "text" : _groupName })
                            );
                        }
                    };

                if (groupNames.length) {
                    var addGroupNames = function(groupNamesToBuild) {
                        $.each(groupNamesToBuild, function(groupNameIdx, groupName) {
                            groupName = $.trim(groupName);
                            if (groupName && !isGroupAdded(groupName)) {
                                var permittedEntity = $(document.createElement("tr")).addClass("permitted-entity").append(
                                    createGroupAvatarCell(groupName)
                                ).append(
                                    $(document.createElement("td")).addClass("delete-permitted-entity").append(
                                        $(document.createElement("a")).addClass("remove").attr("href", "#").attr("title", AJS.I18n.getText("delete.name")
                                        ).text(AJS.I18n.getText("delete.name")
                                        ).click(function() {
                                                $(this).closest("tr").remove();
                                                that._showHideHint(restrictionGroup);
                                                return false;
                                            })
                                    )
                                ).data("entity", groupName);

                                if (addGroupsToTopOfList) {
                                    permittedEntity.prependTo(permittedEntities);
                                } else {
                                    permittedEntities.append(permittedEntity);
                                }
                            }
                        });
                    };

                    var errorContainer = $(".error", restrictionsFieldGroup);
                    if (validate) {
                        var validGroupNames;
                        var invalidGroupNames;

                        $.ajax({
                            cache: false,
                            data : {
                                "groupNames": $.map(groupNames, function(groupName) {
                                    return $.trim(groupName);
                                })
                            },
                            dataType: "json",
                            success : function(_validGroupNames) {
                                validGroupNames = _validGroupNames;
                                invalidGroupNames = $.map(groupNames, function(groupName) {
                                    return $.inArray($.trim(groupName), validGroupNames) === -1 ? $.trim(groupName) : null;
                                });
                                addGroupNames(validGroupNames);

                                errorContainer.empty();
                                if (invalidGroupNames.length) {
                                    errorContainer.text(AJS.format(AJS.I18n.getText("calendar3.error.invalidgroupnames"), invalidGroupNames.join(", ")));
                                }

                                that._showHideHint(restrictionGroup);
                            },
                            type: "GET",
                            timeout: that.calendarPlugin.ajaxTimeout,
                            url: that.calendarPlugin.getCalendarServiceBaseUrl(that.calendarDiv, "/util/validate/group.json")
                        });
                    } else {
                        errorContainer.empty();
                        addGroupNames(groupNames);
                        that._showHideHint(restrictionGroup);
                    }
                }
            }
        });

        return RestrictionDialog;
    });