define("tc/calendar-add-dialog",
    [
        "jquery",
        "tc-backbone",
        "tc/templates",
        "tc/dialogs",
        "tc/util",
        "tc/calendar-util"
    ],
    function (
        $,
        Backbone,
        Templates,
        Dialogs,
        Util,
        CalUtil) {
    "use strict";
    var dialog;

    var CalendarAddDialogView = Backbone.View.extend({
        events: {
            "click .option-new": "addNewCalendar",
            "click .option-existing": "addExistingCalendar",
            "click .option-subscription": "subscribeByUrl",
            "click .option-import": "importCalendar"

        },

        defaults: {
            title: AJS.I18n.getText("calendar3.addcalendar")
        },

        initialize: function(options) {
            options = options || {};
            this.callbackHandler = options.callbackHandler;
            this.dialogOptions = $.extend({}, this.defaults, options.dialogOptions);
        },

        hide: function() {
            dialog.hide();

            //Backbone.View.prototype.remove.call(this, arguments);
        },

        render: function () {
            if (!dialog) {
                dialog = this.dialog = new AJS.Dialog(600, 320, "add-calendar-dialog");

                dialog.addHeader(this.dialogOptions.title);

                dialog.addPanel(
                    this.dialogOptions.title,
                    Templates.addDialog(),
                    "add-calendar-panel"
                );

                if (this.dialogOptions.addClass) {
                    $("#add-calendar-dialog").addClass(this.dialogOptions.addClass);
                }

                dialog.addCancel(AJS.I18n.getText("cancel.name"), function () {
                    dialog.hide();
                    return false;
                });

                this.setElement(dialog.getCurPanel().body);
            }

            dialog.show();
        },

        addNewCalendar: function() {
            var subCalendarDialog = Dialogs.getSubCalendarCreateDialog("parent", this.callbackHandler);
            Util.showDialogInUpdatedHeight(subCalendarDialog);
            $("input[name='name']", subCalendarDialog.getCurrentPanel().body).focus();
            CalUtil.fireEventForAnalytics("add.calendar.click.new." + CalUtil.getCalendarContext());
            this.hide();
        },

        addExistingCalendar: function() {
            var inPage = $("meta[name='ajs-page-id']").length >= 1;

            var subCalendarSubscribeDialog = Dialogs.getSubCalendarSubscribeDialog(
                $.extend({
                    callbackHandler: this.callbackHandler,
                    heading: inPage ? AJS.I18n.getText("calendar3.searchcalendars") : AJS.I18n.getText("calendar3.popularcalendars"),
                    showSearch: inPage,
                    searchParams: {
                        "showSubCalendarsInView": AJS.Meta.get("space-key") !== undefined || inPage
                    },
                    disableWatching: inPage,
                    id: "internal-subscription-calendar-dialog"
                })
            );

            Util.showDialogInUpdatedHeight(subCalendarSubscribeDialog);
            CalUtil.fireEventForAnalytics("add.calendar.click.existing." + CalUtil.getCalendarContext());
            this.hide();
        },

        subscribeByUrl: function() {
            var subCalendarDialog = Dialogs.getSubCalendarCreateDialog("subscription", this.callbackHandler);
            Util.showDialogInUpdatedHeight(subCalendarDialog);
            $("input[name='name']", subCalendarDialog.getCurrentPanel().body).focus();
            CalUtil.fireEventForAnalytics("add.calendar.click.subscribe." + CalUtil.getCalendarContext());
            this.hide();
        },

        importCalendar: function() {
            var subCalendarDialog = Dialogs.getSubCalendarImportDialog(this.callbackHandler);
            Util.showDialogInUpdatedHeight(subCalendarDialog);
            $("input[name='name']", subCalendarDialog.getCurrentPanel()).focus();
            CalUtil.fireEventForAnalytics("add.calendar.click.import." + CalUtil.getCalendarContext());
            this.hide();
        }
    });

    return CalendarAddDialogView;
});
