/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.lucenecompat.impl;

import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;

public class Lucene4FieldDescriptorMapper {
    private static final Map<FieldDescriptor.Index, Field.Index> luceneIndexMapping = new HashMap<FieldDescriptor.Index, Field.Index>(){
        {
            this.put(FieldDescriptor.Index.NO, Field.Index.NO);
            this.put(FieldDescriptor.Index.NOT_ANALYZED, Field.Index.NOT_ANALYZED);
            this.put(FieldDescriptor.Index.ANALYZED, Field.Index.ANALYZED);
        }
    };
    private static final Map<FieldDescriptor.Store, Field.Store> luceneStoreMapping = new HashMap<FieldDescriptor.Store, Field.Store>(){
        {
            this.put(FieldDescriptor.Store.NO, Field.Store.NO);
            this.put(FieldDescriptor.Store.YES, Field.Store.YES);
        }
    };

    public Object map(FieldDescriptor fieldDescriptor) {
        FieldDescriptor.Store store = fieldDescriptor.getStore();
        Field.Store fieldStore = luceneStoreMapping.get(store);
        FieldDescriptor.Index index = fieldDescriptor.getIndex();
        Field.Index fieldIndex = luceneIndexMapping.get(index);
        String fieldName = fieldDescriptor.getName();
        String fieldValue = fieldDescriptor.getValue();
        if (index == FieldDescriptor.Index.NOT_ANALYZED) {
            return new StringField(fieldName, fieldValue, fieldStore);
        }
        if (index == FieldDescriptor.Index.ANALYZED) {
            return new TextField(fieldName, fieldValue, fieldStore);
        }
        if (store == FieldDescriptor.Store.YES) {
            return new StoredField(fieldName, fieldValue);
        }
        return new Field(fieldName, fieldValue, fieldStore, fieldIndex);
    }
}

