/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.lucenecompat;

import com.atlassian.bonnie.LuceneConnection;
import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.spring.container.ContainerManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.lucene.document.Document;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Extractor2ToExtractorAdapter
implements Extractor {
    private static final Logger log = LoggerFactory.getLogger(Extractor2ToExtractorAdapter.class);
    private ServiceTracker serviceTracker;
    private static final String adaptingExtractorClassName = "com.atlassian.labs.lucenecompat.impl." + (Extractor2ToExtractorAdapter.isLucene4() ? "Lucene4" : "Lucene29") + "AdaptingExtractor";
    private final Constructor<Extractor> adaptingExtractorConstructor;

    public Extractor2ToExtractorAdapter() {
        try {
            Class<?> adaptingExtractorClass = this.getClass().getClassLoader().loadClass(adaptingExtractorClassName);
            this.adaptingExtractorConstructor = adaptingExtractorClass.getConstructor(Extractor2.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void addFields(Document document, StringBuffer contentBody, Searchable searchable) {
        ServiceReference[] serviceReferences = this.getServiceTracker().getServiceReferences();
        if (serviceReferences == null) {
            return;
        }
        for (ServiceReference serviceReference : serviceReferences) {
            Object service = this.getServiceTracker().getService(serviceReference);
            if (!(service instanceof Extractor2)) continue;
            Extractor2 extractor2 = (Extractor2)service;
            try {
                this.adaptingExtractorConstructor.newInstance(extractor2).addFields(document, contentBody, searchable);
            }
            catch (RuntimeException e) {
                log.error("Error extracting search fields from " + searchable + " using " + extractor2 + ": " + e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error("Error creating adapting extractor", (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error("Error creating adapting extractor", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("Error creating adapting extractor", (Throwable)e);
            }
        }
    }

    protected ServiceTracker getServiceTracker() {
        if (this.serviceTracker == null) {
            OsgiContainerManager osgiContainerManager = (OsgiContainerManager)ContainerManager.getComponent((String)"osgiContainerManager");
            this.serviceTracker = osgiContainerManager.getServiceTracker(Extractor2.class.getName());
        }
        return this.serviceTracker;
    }

    private static boolean isLucene4() {
        try {
            Class.forName("org.apache.lucene.index.IndexableField", false, LuceneConnection.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

